function s=GibbsStats(s,v,drop,display)
if nargin<4; display=true; end;
if nargin<3; drop=.2; end;

x = s.(v);
n = length(v);

if drop>1
   ndrop = drop;
else
   ndrop = floor(drop*n);
end

nuse = n-ndrop;
y=x(ndrop+1:end);

xmean = mean(y);
xmedian = median(y);
xmin = min(y);
xmax = max(y);
xsd = std(y);
s = [xmean xmedian xsd xmin xmax];
if display;
    a = sprintf('%12s mean=%8.3g median=%8.3g std=%8.3g min=%8.3g max=%8.3g',...
        v,xmean,xmedian,xsd,xmin,xmax);
    disp(a);
end;